# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 3
# Experiment: PMxPM, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR3(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    total_rounds = 10
    
    # Initial move: Cooperate
    if current_round == 1:
        return "C"
    
    # Check for deterministic opponent strategies
    always_cooperate = "always cooperate" in opponent_program_code.lower() or "return 'C'" in opponent_program_code.lower()
    always_defect = "always defect" in opponent_program_code.lower() or "return 'D'" in opponent_program_code.lower()
    
    if always_defect:
        return "D"
    if always_cooperate and current_round >= 2:
        return "D"
    
    # Early rounds (2-4): Tit-for-Tat
    if 2 <= current_round <= 4:
        return opp_history[-1]
    
    # Middle rounds (5-7): Random defection or switch to always defect if opponent defected more than twice
    if 5 <= current_round <= 7:
        if opp_history.count("D") > 2:
            return "D"
        if random.random() < 0.2:
            return "D"
        return opp_history[-1]
    
    # Late rounds (8-10): Defect in last two rounds unless opponent consistently cooperated
    if current_round >= 8:
        if opp_history.count("D") == 0:
            if current_round == total_rounds:
                return "D"
            return "C"
        else:
            if current_round >= total_rounds - 1:
                return "D"
            return opp_history[-1]
    
    # Default fallback
    return "C"